#!/bin/csh

# without empirical dispersion
foreach theory ( "BP86" "BLYP" "PBEPBE" "TPSSTPSS" "revTPSSrevTPSS" "M06L" "B3LYP" "CAM-B3LYP" "wB97XD" "MN15" )
   echo Setting up $theory calculations
   touch $theory; \rm -rf $theory; mkdir $theory
   foreach file (`ls *.inp | awk -F. '{print $1}'`)
       echo "	"Looking at $file
       sed 's/THEORY/'${theory}'/g' ${file}.inp > $theory/${file}.inp
       cd $theory
       g16submit -n 16 ${file}.inp
       cd ..
   end
end

# with empirical dispersion
foreach theory ( "CAM-B3LYP" )
   echo Setting up ${theory}+ED calculations
   touch ${theory}+ED; \rm -rf ${theory}+ED; mkdir ${theory}+ED
   foreach file (`ls *.inp | awk -F. '{print $1}'`)
       echo "	"Looking at $file
       sed 's/THEORY/'${theory}'/g' ${file}.inp | sed 's/Auto/Auto EmpiricalDispersion(GD3BJ)/g' > ${theory}+ED/${file}.inp
       cd ${theory}+ED
       g16submit -n 16 ${file}.inp
       cd ..
   end
end

